#methods
##Overview
In **RESTup5** a **"Method"** is a class which contains a specific set of functions which provide the back-end for a RESTful Web Service Resource (end point), for example:
>/genClientKey is a Method which generates a clientKey, this method uses only the HTTP 1.1 GET method, any of the other CRUD methods (PUT, POST or DELETE) wil result in a 405 error.

A method has the following core structure:
+ a method extends the abstract Method class (bin/Method.php) **class genClientKey extends Method** in the example below.
+ a method may override several of the system wide variables which are configured in /bin/base.php, in the conf/{methodName}.json file, as is the case in conf/genClientKey.json where the requestMethods array contains only the **GET** method.
+ a method must have a public execute function which overrides the one inherrited from bin/Method.php.
+ a method may also override the public respond function inherrited from bin/Method.php

**Note:** see [**tutorials**](/tutorials) for detailed information on methods.

##An example
>
<dl><dt>Listing of conf/genClientKey.json</dt>
<dd><pre>
{
&nbsp;&nbsp;&nbsp;&nbsp;"authentication":false,
&nbsp;&nbsp;&nbsp;&nbsp;"requestProtocols":["https","http"],
&nbsp;&nbsp;&nbsp;&nbsp;"requestMethods":["GET"],
&nbsp;&nbsp;&nbsp;&nbsp;"respType":"json"
}
</pre>
</dd>
</dl>

>
<dl><dt>Listing of genClientKey</dt>
<dd>
<pre>
&lt;?php
/**
&nbsp;&nbsp;* Project:    RESTup5:       A RESTful webservices and systems applications server platform written in PHP for Linux/Unix Operating Systems
&nbsp;&nbsp;* File:       genClientKey.php
&nbsp;&nbsp;* GIT:        $Id: $
&nbsp;&nbsp;* Source version: $Rev: 5000 $
&nbsp;&nbsp;* Date: $Date: 2016-10-12 02:00:00Z (Wed, 12 Oct 2016) $
&nbsp;&nbsp;* Modified by: $Author: Administrator $
&nbsp;&nbsp;* This library is free software; you can redistribute it and/or
&nbsp;&nbsp;* modify it under the terms of the GNU Lesser General Public
&nbsp;&nbsp;* License as published by the Free Software Foundation; either
&nbsp;&nbsp;* version 3.0 of the License, or (at your option) any later version.
&nbsp;&nbsp;* This library is distributed in the hope that it will be useful,
&nbsp;&nbsp;* but WITHOUT ANY WARRANTY; without even the implied warranty of
&nbsp;&nbsp;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
&nbsp;&nbsp;* Lesser General Public License for more details.
&nbsp;&nbsp;*
&nbsp;&nbsp;* Put simply: you may incorporate this library into your own products, however
&nbsp;&nbsp;* If you modify the source code of this library in any way, you MUST make the 
&nbsp;&nbsp;* source code, including your modifications, available to anyone who requests the source.
&nbsp;&nbsp;*
&nbsp;&nbsp;* You should have received a copy of the GNU Lesser General Public
&nbsp;&nbsp;* License along with this library; if not, write to the Free Software
&nbsp;&nbsp;* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
&nbsp;&nbsp;* For questions, help, comments, discussion, etc., please email George Embrey <george.embrey@covirtual.net>
&nbsp;&nbsp;*
&nbsp;&nbsp;* @link       http://www.covirtual.net/RESTup
&nbsp;&nbsp;* @copyright  2009 - 2016 RESTup framework, all versions, developed by CoVirtual.Net Pty Ltd, Sydney Australia.
&nbsp;&nbsp;* @author     George Embrey <george dot embrey at covirtual dot net>
&nbsp;&nbsp;* @package    RESTup5
&nbsp;&nbsp;* @version    5000
&nbsp;&nbsp;* @file       genClientKey.php
&nbsp;&nbsp;* @brief genClientKey generate a client key for a RESTup5 server
&nbsp;&nbsp;*/
class genClientKey extends Method
{
&nbsp;&nbsp;/**
&nbsp;&nbsp;&nbsp;&nbsp;* Variable Deffinitions
&nbsp;&nbsp;&nbsp;&nbsp;*/
&nbsp;&nbsp;&nbsp;&nbsp;public  $respType="json";
&nbsp;&nbsp;&nbsp;&nbsp;public  $appLog="";
&nbsp;&nbsp;&nbsp;&nbsp;public  $debugLog="";
&nbsp;&nbsp;&nbsp;&nbsp;public  $errorLog="";
&nbsp;&nbsp;&nbsp;&nbsp;public  $confFile = "genClientKey.json";
&nbsp;&nbsp;&nbsp;&nbsp;public  $config="";
&nbsp;&nbsp;&nbsp;&nbsp;public  $data="";
&nbsp;&nbsp;&nbsp;&nbsp;public  $debugLevel=0;<br />
&nbsp;&nbsp;/**
&nbsp;&nbsp;&nbsp;&nbsp;* class constructor
&nbsp;&nbsp;&nbsp;&nbsp;*
&nbsp;&nbsp;&nbsp;&nbsp;*/
&nbsp;&nbsp;&nbsp;&nbsp;public function __construct()
&nbsp;&nbsp;&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;parent::__construct();
&nbsp;&nbsp;&nbsp;&nbsp;}<br />
&nbsp;&nbsp;&nbsp;&nbsp;private function genClientKey()
&nbsp;&nbsp;&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$host=md5(exec("hostname"));
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$mdt=md5(microtime(true));
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// $mdt=system("uuid");
&nbsp;&nbsp;&nbsp;&nbsp;return substr($mdt,0,8)."-".substr($mdt,8,4)."-".substr($mdt,12,4)."-".substr($mdt,16,12)."-".substr($host,0,12)."-".substr($host,12,4)."-".substr($host,16,4)."-".substr($host,20,5);
&nbsp;&nbsp;&nbsp;&nbsp;}<br />
&nbsp;&nbsp;&nbsp;&nbsp;public function execute()
&nbsp;&nbsp;&nbsp;&nbsp;{
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$this->data['clientKey']=$this->genClientKey();
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$this->respond();
&nbsp;&nbsp;&nbsp;&nbsp;}
}
?&gt;
</pre>
</dd>
</dl>
Typical output from /genClientKey: {"clientKey":"3dc56ac9-3630-b29a-6d71475e97a2-e7201a57630e-dfe9-9f83-48ade"}

##Support##
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/tutorials"><em>Tutorials</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
