#/lib
##REST Methods
The **/lib** directory is where all REST methods are stored, these are methods which, by default, return **'application/json' (JSON)** results as opposed to views which return HTML, alternate response types include:
+ 'application/xml' (XML)
+ 'text/csv' (.csv)
+ 'text/tab-separated-values' (.tsv)
+ 'application/msword' (.doc)
+ 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' (.docx)
+ 'application/pdf' (.pdf)
+ 'application/vnd.ms-powerpointtd' (.ppt)
+ 'application/vnd.openxmlformats-officedocument.presentationml.presentation' (.pptx)
+ 'application/vnd.ms-excel' (.xls)
+ 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' (.xlsx)

##Included REST Methods
>By default, the RESTup5 platform ships with the following REST methods:
>
| Method Name | called as | parameters | returns |
| :------------- | :----------------- | :--------------------- | :--------------------------- |
| genClientKey.php | [/genClientKey](/genClientKey) | | JSON object containing a clientKey |
| getData.php | [/getData](/getData) | $rf method to retrieve the result set from. (Method MUST exist)<br>$data JSON object containing parameters to be passed to the method | JSON object including result set or error details |
| getODBCData.php | [/getData](/getData) | $rf method to retrieve the result set from. (Method MUST exist)<br>$data JSON object containing parameters to be passed to the method | JSON object including result set or error details |
| putData.php | [/putData](/putData) |  $rf method used to store the information in data. (Method MUST exist)<br>$data JSON object containing parameters to be passed to the method | JSON object including result set or error details |

##Security
All of the usual platform and client security restrictions apply to these methods, eg: unauthenticated clients require valid clientKeys in the request, the keys must be in the server clientKeys array in /conf/serverConf.json otherwise the client connection and request will result in an error being received.  Such failures may be placed in the error.log and tracked with security tools like fail2ban which can deny access to the server entirely. 

##Support
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
