#Core#
##Core Variables##
Core variables are those which are built-in to the RESTup5 platform and are available to all [connectors](/connectors), [methods](/methods) and [views](/views) of the platform.

>**List of core -- fixed variables**
>
| variable | description | override |
| :------- | :---------- | :------: |
| $baseDir | system file path to the RESTup5 platform file system | <red>N</red> |
| $baseURL | the base url of the RESTup5 platform, derived from the $_SERVER super global | <red>N</red> |
| $binDir | the directory which contains the core Classes and Libraries of the RESTup5 Platform | <red>N</red> |
| $compiledTemplatesDir | the directory where compiled Twig templates are stored | <red>N</red> |
| $confDir | the directory where RESTup5 configuration files are stored | <red>N</red> |
| $connDir | the directory where RESTup5 connectors are stored | <red>N</red> |
| $docDir | the directory where RESTup5 platform documentation is stored | <red>N</red> |
| $libDir | the directory where REST methods are stored | <red>N</red> |
| $logDir | the directory where log files are stored | <red>N</red> |
| $RESTupVersion | Version of the RESTup Platform | <red>N</red> |
| $showDocs | toggle for enabling RESTup platform documentation to be displayed, configured in /conf/serverConf with "showDocs: (true / false) | <red>N</red> |
| $tempDir | the directory where temporary files are stored | <red>N</red> |
| $templatesDir | the directory where RESTup5 templates are stored | <red>N</red> |
| $uploadsDir | the directory where file uploads are stored by web applications | <red>N</red> |
| $viewsDir | the directory where views are stored | <red>N</red> |
<br />
>**List of core -- override variables** (May be set per view).
>
| variable | description | override |
| :------- | :---------- | :------: |
| $debugLevel | Integer setting the verbosity of debug information written to the /log/debug.log file | <green>Y</green> |
| $footerFile | the name of the page footer file (default 'footer.php') | <green>Y</green> |
| $headerFile | the name of the page header file (default 'header.php') | <green>Y</green> |
| $pageCSS | mixed (string or array of string) containing either:<br />&lt;link rel="stylesheet ... &gt;<br />&nbsp;&nbsp;or<br />&lt;style&gt; ... &lt;/style&gt; <br/>css. | <green>Y</green> |
| $pageTopJS | mixed (string or array of string) containing either:<br />&lt;script type="text/javascript" href="/js/blah.js"&gt;<br />&nbsp;&nbsp;or<br />&lt;script type="text/javascript"&gt; ... &lt;/script&gt; <br/>javascript that loads in th head tag of a page. | <green>Y</green> |
| $pageBotJS | mixed (string or array of string) containing either:<br />&lt;script type="text/javascript" href="/js/blah.js"&gt;<br />&nbsp;&nbsp;or<br />&lt;script type="text/javascript"&gt; ... &lt;/script&gt; <br/>javascript that loads after the page footer in a page. | <green>Y</green> |
| $reqMethodOrView | the originally requested method or view prior to any view overrides eg: $methodToggle=true. | <green>Y</green> |
| $seoDescription | set the description meta tag contents in this variable | <green>Y</green> |
| $seoKeywords | set the keywords meta tag contents in this variable | <green>Y</green> |
<br />
>**List of core -- internal variables**
>
| variable | description | ro, rw or w |
| :------- | :---------- | :------: |
| $conf | array - holds the server configuration as decoded from the /conf/serverConf.json file | <blue>RO</blue> |
| $cookieName | string - name of the default client cookie for authenticated users (default restup5.0) | <blue>RO</blue> |
| $curMethodOrView | the current method or view derived from http request from the client. | <blue>RO</blue> |
| $curTemplate | the current template derived from the current method or view. | <blue>RO</blue> |
| $extraCSS | string - read only variable containing CSS derived from the contents of $pageCSS | <blue>RO</blue> |
| $extraBotJS | string - read only variable containing JS (javascript) derived from the contents of $pageBotJS | <blue>RO</blue> |
| $extraTopJS | string - read only variable containing JS (javascript) derived from the contents of $pageTopJS | <blue>RO</blue> |
| $hasSessionCookie | boolean - value set at runtime: true if a session cookie exists, false otherwise. | <blue>RO</blue> |
| $incDefHdrFtrTemplate | boolean - (default false), determines whether to include (if they exist):<br />**/templates/defaultPageHeader.html**<br />&nbsp;&nbsp;and<br />**/templates/defaultPageFooter.html**<br />Used with views which generally are .inc files, but may also be set for any other view type | <green>RW</green> |
| $methodLoaded | boolean indicating whether the current method or view has been loaded. | <blue>RO</blue> |
| $pageTitle | the text to be displayed as page title for the current page | <green>RW</green> |
| $session_lifetime | integer - number of milliseconds until the session expires (default 36000 or 10 hours) | <green>RW</green> |
| $session | string - contains the php_session value which is set at runtime (default '') | <blue>RO</blue> |
| $strNameValuePairs | name value pairs derived from the client request | <blue>RO</blue> |
| $trimmedStrURI | the trimmed url from the client request | <blue>RO</blue> |
| $viewExtn | the file extension of the method or view being executed | <blue>RO</blue> |
| $viewHTML | buffer which contains the rendered html for the current view | <blue>RO</blue> |


##Core functions##
Core functions are those defined by the platform and are available to all [connectors](/connectors), [methods](/methods) and [views](/views) of the platform.

>**List of core functions**
>
| function | description | parameter name | type | range | max length |
| :------- | :---------- | :------------- | :-------- | :----------- | :---------------- |
| readConf | read the specified JSON config file | $f | string | | 1023 |
| initServer | initialize the server, called once per method or view loads **/conf/serverConf.json** | | | | |
| __autoload | the RESTup5 platform autoloader function used to load methods, views, modules, sets $methodLoaded to true if the method is loaded | $M | string | | 255 |
| array2string | converts an array to a printable string | $arr | array | | |
| strToHex | convert a string to its' hexadecimal representation, complements the javascript function asc2hex the /js/cvForms.js | $string | string |  | 65535 |
| hexToStr | convert a hexidecimal string to an ascii string, complements the javascript function hex2asc in the /js/cvForms.js | $hex | hex encoded string |  | 65535 |
| xml_to_array | parses XML into an associative array | $xml | string |  | no 20MB |
| arrayToXml | converts an associative array to well formed XML  | $array | array |  | 20MB |
| jsonToXML | convert a json string into well formed XML | $strJSON | string |  | 20MB |
| genPassword | generate a strong password | $pwdLength<br />$flags | integer<br />integer | 8-255<br />0 - 15 | 255 max |
| getCookieKeyValue | get the contents of a cookie, optionally retrieve only a specified key | $cookie<br />$key | string<br />string or null |  | 65535 |
| setCookieKeyValue | set the contents of the specified cookie, key and value | $cookie<br />$key<br />$value | string<br />string<br />string |  | 65535 |
| delCookieKey | delete a key from a cookie | $cookie<br />$key | string<br />string |  | 65535 |
| verifyUserLoggedIn | checks whether a client has an authentication cookie for username / password authenticated users |  |  |  |  |
| logoff | destroys session and user cookies when an authenticated user chooses to logoff. |  |  |  |  |
| is_json | return true if the specified string is valid json, otherwise false | $s | string |  | 20MB |
| makePageTitle | generates a correctly capitalised string from the specified string (most commonly $currentMethodOrView is passed to this function. | $cmv | string |  | 65535 |
| apache_request_headers | returns an array of Apache Request Headers. |  |  |  |  |
| checkIpV4Address | returns true if the TCP I/P Address in $addr is in the block of addresses specified by the array of CIDRs $arrCIDRs, otherwise false. | $addr<br/>$arrCIDRs | string<br/>CIDRs array |  | 15<br/>65535 |

##Support##
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
