#/connectors
Connectors are special classes which abstract the CRUD functions associated with data sources and prevent SQL injection and many other malicious attacks.

A connector exposes methods (functions) for connecting to one datasource, executiong predifined parameterised queries, and executing code where appropriate, to return a specific dataset or false if the operation fails.

The **DB_sample** connector in the example below extends the Abstract class **DB_MySQL**, it inherrits all of the properties and methods (functions) from **DB_MySQL**, overrides some of the properties and extends the class 
by adding the public function:
```
    public function getUserDetails($data=null)
    {
    ...
    }
```
which returns the userID, userParentID, userFullName, userRoles and userStatus for the userName and userPassword specified in the $data (object | array | json) input parameter otherwise false if the user does not exist or the input parameters are invalid.

###DB_sample.php - sample database connector.

```
<?php
/**
    *************************************************************************
    * Notice this is a sample connector only and is here to demonstrate how *
    * Database Connections and methods are created in the RESTup5 framework *
    *************************************************************************
*/

/**
  * Project:    RESTup5  RESTful Web Services Framework
  * File:       DB_sample.php
  * GIT:        $Id: $
  * Source version: $Rev: 5000 $
  * Date: $Date: 2016-10-12 02:00:00Z (Wed, 12 Oct 2016) $
  * Modified by: $Author: Administrator $
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 3.0 of the License, or (at your option) any later version.
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * Put simply: you may incorporate this library into your own products, however
  * If you modify the source code of this library in any way, you MUST make the 
  * source code, including your modifications, available to anyone who requests the source.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  * For questions, help, comments, discussion, etc., please email George Embrey <george.embrey@covirtual.net>
  *
  * @link       http://www.covirtual.net/RESTup
  * @copyright  2009 - 2016 RESTup framework, all versions, developed by CoVirtual.Net Pty Ltd, Sydney Australia.
  * @author     George Embrey <george dot embrey at covirtual dot net>
  * @package    RESTup5
  * @version    5000
  * @file       DB_sample.php
  * @brief      DB_sample is the MySQL database connector for the sample database extening the DB_MySQL class of the RESTup5 php framework, providing data methods for the sample database to 
web applications and system scripts.
  */
class DB_sample extends DB_MySQL
{
    public $confFile="DB_sample.json";
    public $photoExtensions='';
    public $documentExtensions='';

    public function __construct()
    {
        parent::__construct();
        // set some variables for for this class
        $this->photoExtensions="'jpg','jpeg','png','gif','bmp','raw'";
        $this->documentExtensions="'pdf','doc','docx','xls','xlsx','ppt','pptx','txt','xml','xsd'";
    }

    public function DBclose()
    {
        parent::__destruct();
    }

    public function getUserDetails($data=null)
    {
        if(!is_null($data)){
            $myData='';
            // if data is an object convert it to an associative array.
            if(is_object($data)){ $myData=json_decode(json_encode($data),true); }

            // if $data is a JSON string convert it to an associative array
            if(is_json($data)) { $myData=json_decode($data,true); }

            // check if $data is an array
            if (is_array($data)) { $myData=$data; }

            // extract the contents of $myData if it is an array.
            if(is_array($myData)) { extract($myData); }

            // obtail the userName to search for and ensure that it us null if it does not exist.
            $userName=(isset($userName)?$userName:null);
            $userPassword=(isset($userPassword)?$userPassword:null);
        }
        // we are going to use the plain-text userPassword for checking against the stored MySQL password.
        $strWhere=((isset($userName) and !empty($userName) and isset($userPassword) and !empty($userPassword))?" where 
            userName='".$userName."' 
            and userPassword=password('".$userPassword."')":'');
        $strSQL="select userID, userParentID, concat(firstName,' ',lastName) userFullName, userRoles, userStatus from users".$strWhere;
        $this->DBQuery($strSQL);
        if(($this->debugLevel & 4)==4){
            $this->debugLog->desc="getUserDetails";
            $this->debugLog->data=$this->LastTransaction;
            $this->debugLog->writeLog();
        }
        return ($this->LastTransaction['NumRows']>=1?$this->LastTransaction['Data']:false);
    }

}
?>
```

##Sample database
The DDL for the sample database **sample.sql** is contained in the [**/database**](/database) directory.

><dl>
<dt>Listing of /database/sample.sql</dt>
<dd>
<pre>
--
-- sample - a sample database for the RESTup5 RESTful Web Services Platform.
--<br />
create database if not exists sample;<br />
use sample;<br />
--
-- This table is for use with mysql 5.6 and above, if using earlier versions, change the default value for created from
-- CURRENT_TIMESTAMP to '2000-01-01 10:00:00' or some other valid date in the past.
--
create table if not exists users (
    userID          bigint  unsigned        not null        auto_increment  primary key,
    userParentID    bigint  unsigned        not null        default 1,
    userName        varchar(30)             not null        default '',
    userPawword     char(41)                not null        default '*E0EA3FA83967803674C4DC584B0F9666F93D00F7',  -- password('Passw0rd1')
    firstName       varchar(30)             not null        default '',
    lastName        varchar(40)             not null        default '',
    primaryEmail    varchar(128)            not null        default '',
    userRoles       integer unsigned        not null        default 1,
    userStatus      integer unsigned        not null        default 1,
    created         datetime                not null        default CURRENT_TIMESTAMP,
    createdBy       bigint  unsigned        not null        default 1,
    updated         datetime                not null        default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
    updatedBy       bigint  unsigned        not null        default 1,
    unique key ix_userDetails (userName, userPawword, firstName, lastName, primaryEmail)
) Engine InnoDB character set 'utf8' comment 'users table';<br />
-- create the admin user.
insert into users values (1,1,'admin',password('sysadmin'),'System','Administrator','sysadmin@localhost','1023',1,now(),1,now(),1);
<br />
-- change the auto_increment value to 10001 to be ready for the first web user.
alter table users auto_increment=10001;
</pre>
</dd>
</dl>

##Support##
Should you require help with configuring your web-server, send an email detailing your web-server server to [customer.support@covirtual.net](mailto:customer.support@covirtual.net).

<dl>
<dt>Useful Links</dt>
<dd>
<a href="/README"><em>Documentation Home</em></a><br />
<a href="/tutorials"><em>Tutorials</em></a><br />
<a href="/"><em>RESTup5 Server</em></a><br />
<a href="http://www.covirtual.net"><em>CoVirtual.Net</em></a>
</dd>
</dl>
